#
#-------------------------------------------------------------
#
#	ROBOTRAN - Version 6.6 (build : february 22, 2008)
#
#	Copyright 
#	Universite catholique de Louvain 
#	Departement de Mecanique 
#	Unite de Production Mecanique et Machines 
#	2, Place du Levant 
#	1348 Louvain-la-Neuve 
#	http://www.robotran.be// 
#
#	==> Generation Date : Mon Jan 27 11:51:33 2020
#
#	==> Project name : pendulum_spring_python
#	==> using XML input file 
#
#	==> Number of joints : 4
#
#	==> Function : F19 : External Forces
#	==> Flops complexity : 28
#
#	==> Generation Time :  0.000 seconds
#	==> Post-Processing :  0.000 seconds
#
#-------------------------------------------------------------
#
import numpy as np  

def extforces(frc,trq,s,tsim):
  
  q = s.q
  qd = s.qd
  qdd = s.qdd
  frc = s.frc
  trq = s.trq
  
  PxF1=np.zeros(4)
  RxF1=np.zeros((4,4))
  VxF1=np.zeros(4)
  OMxF1=np.zeros(4)
  AxF1=np.zeros(4)
  OMPxF1=np.zeros(4)

# === begin imp_aux === 

# === end imp_aux === 

# ===== BEGIN task 0 ===== 
 
# Sensor Kinematics 



# = = Block_0_0_0_0_0_1 = = 
 
# Trigonometric Variables  

  C1 = np.cos(q[1])
  S1 = np.sin(q[1])

# = = Block_0_0_1_1_0_1 = = 
 
# Sensor Kinematics 


  RLcp1_110 = s.dpt[3,5]*S1
  RLcp1_310 = s.dpt[3,5]*C1
  ORcp1_110 = qd[1]*RLcp1_310
  ORcp1_310 = -qd[1]*RLcp1_110
  PxF1[1] = RLcp1_110
  PxF1[2] = 0
  PxF1[3] = RLcp1_310
  RxF1[1,1] = C1
  RxF1[1,2] = 0
  RxF1[1,3] = -S1
  RxF1[2,1] = 0
  RxF1[2,2] = (1.0)
  RxF1[2,3] = 0
  RxF1[3,1] = S1
  RxF1[3,2] = 0
  RxF1[3,3] = C1
  VxF1[1] = ORcp1_110
  VxF1[2] = 0
  VxF1[3] = ORcp1_310
  OMxF1[1] = 0
  OMxF1[2] = qd[1]
  OMxF1[3] = 0
  AxF1[1] = qd[1]*ORcp1_310+qdd[1]*RLcp1_310
  AxF1[2] = 0
  AxF1[3] = -(qd[1]*ORcp1_110+qdd[1]*RLcp1_110)
  OMPxF1[1] = 0
  OMPxF1[2] = qdd[1]
  OMPxF1[3] = 0
 
# Sensor Forces Computation 

  SWr1 = s.user_ExtForces(PxF1,RxF1,VxF1,OMxF1,AxF1,OMPxF1,s,tsim,1)
 
# Sensor Dynamics : Forces projection on body-fixed frames 

  xfrc12 = SWr1[1]*C1-SWr1[3]*S1
  xfrc22 = SWr1[2]
  xfrc32 = SWr1[1]*S1+SWr1[3]*C1
  frc[1,1] = s.frc[1,1]+xfrc12
  frc[2,1] = s.frc[2,1]+SWr1[2]
  frc[3,1] = s.frc[3,1]+xfrc32
  xtrq12 = SWr1[4]*C1-SWr1[6]*S1
  xtrq22 = SWr1[5]
  xtrq32 = SWr1[4]*S1+SWr1[6]*C1
  trq[1,1] = s.trq[1,1]+xtrq12-xfrc22*(SWr1[9]-s.l[3,1])+xfrc32*SWr1[8]
  trq[2,1] = s.trq[2,1]+xtrq22+xfrc12*(SWr1[9]-s.l[3,1])-xfrc32*SWr1[7]
  trq[3,1] = s.trq[3,1]+xtrq32-xfrc12*SWr1[8]+xfrc22*SWr1[7]

# = = Block_0_0_1_1_1_0 = = 
 
# Symbolic Outputs  

  frc[1,2] = s.frc[1,2]
  frc[2,2] = s.frc[2,2]
  frc[3,2] = s.frc[3,2]
  frc[1,3] = s.frc[1,3]
  frc[2,3] = s.frc[2,3]
  frc[3,3] = s.frc[3,3]
  frc[1,4] = s.frc[1,4]
  frc[2,4] = s.frc[2,4]
  frc[3,4] = s.frc[3,4]
  trq[1,2] = s.trq[1,2]
  trq[2,2] = s.trq[2,2]
  trq[3,2] = s.trq[3,2]
  trq[1,3] = s.trq[1,3]
  trq[2,3] = s.trq[2,3]
  trq[3,3] = s.trq[3,3]
  trq[1,4] = s.trq[1,4]
  trq[2,4] = s.trq[2,4]
  trq[3,4] = s.trq[3,4]

# ====== END Task 0 ====== 

  

